#include <bits/stdc++.h>
using namespace std;

struct Tacka {
    long long x, y;
};

void zameniTacke(Tacka& t1, Tacka& t2) {
    Tacka temp = t1;
    t1 = t2;
    t2 = temp;
}

long long kvDuz(Tacka t1, Tacka t2) {
    return (t1.x - t2.x) * (t1.x - t2.x) + (t1.y - t2.y) * (t1.y - t2.y);
}

int nadjiUgao(Tacka t1, Tacka t2, Tacka t3) {
    int ugao = (t2.y - t1.y) * (t3.x - t2.x) - (t2.x - t1.x) * (t3.y - t2.y);
    if (ugao == 0) return 0;
    return (ugao > 0) ? 1 : 2;
}

Tacka t0;

int uporedi(const void* pok1, const void* pok2) {
    Tacka* t1 = (Tacka*)pok1;
    Tacka* t2 = (Tacka*)pok2;

    int ugao = nadjiUgao(t0, *t1, *t2);
    if (ugao == 0) return (kvDuz(t0, *t2) >= kvDuz(t0, *t1)) ? -1 : 1;
    return (ugao == 2) ? -1 : 1;
}

Tacka preNajv(stack<Tacka>& s) {
    Tacka t = s.top(), r;
    s.pop();
    r = s.top();
    s.push(t);
    return r;
}

vector<Tacka> konveksniOmotac(Tacka tacke[], int n) {
    long long ynajm = tacke[0].y, minimalna = 0;
    for (int i = 1; i < n; i++) {
        if ((tacke[i].y < ynajm) || (tacke[i].y == ynajm && tacke[i].x < tacke[minimalna].x)) {
            ynajm = tacke[i].y;
            minimalna = i;
        }
    }
    zameniTacke(tacke[0], tacke[minimalna]);
    t0 = tacke[0];
    qsort(&tacke[1], n - 1, sizeof(Tacka), uporedi);

    vector<Tacka> omotac;
    omotac.push_back(tacke[0]);
    for (int i = 1; i < n; i++) {
        while (omotac.size() > 1 &&
            nadjiUgao(omotac[omotac.size() - 2], omotac[omotac.size() - 1], tacke[i]) != 2) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }
    return omotac;
}

long long izracunajPovrsinu(vector<Tacka>& omotac) {
    long long povrsina = 0;
    int n = omotac.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        povrsina += (long long)omotac[i].x * omotac[j].y - (long long)omotac[i].y * omotac[j].x;
    }
    return abs(povrsina) / 2;
}

long long najmKonvSkoroOmotac(Tacka tacke[], int n) {
    vector<Tacka> omotac = konveksniOmotac(tacke, n);
    long long najmPovrsina = LLONG_MAX;

    for (int i = 0; i < omotac.size(); i++) {
        vector<Tacka> bezJedne;
        for (int j = 0; j < omotac.size(); j++) {
            if (i != j) bezJedne.push_back(omotac[j]);
        }
        if (bezJedne.size() <= 2) continue;
        long long povrsina = izracunajPovrsinu(bezJedne);
        najmPovrsina = min(najmPovrsina, povrsina);
    }
    return najmPovrsina;
}

int main() {
    int n;
    cin >> n;

    Tacka nizTacaka[100000];
    for (int i = 0; i < n; i++) cin >> nizTacaka[i].x >> nizTacaka[i].y;

    cout << najmKonvSkoroOmotac(nizTacaka, n) << endl;

    return 0;
}